# ==========================================
# ADS Watchdog - SAFE VARIJANTA
# Radi SAMO pametni prvi restart posle boota
# ==========================================

# ---------- PODESIVI PARAMETRI ----------

# Port na kome Advantage slusa (ako zelis da gleda konekcije, default 6262)
$adsPort = 6262

# Koliko da saceka posle paljenja sistema pre provere za prvi restart
$initialDelaySeconds = 30

# Lokacija log fajla
$logFile = "C:\ADS_Watchdog\ads-watchdog.log"

# ---------- LOG ROTACIJA ----------

try {
    if (Test-Path $logFile) {
        $maxSizeBytes = 5MB
        $file = Get-Item $logFile
        if ($file.Length -gt $maxSizeBytes) {
            Remove-Item $logFile -Force
        }
    }
}
catch {
    # ako pukne rotacija, samo nastavi - nije kriticno
}

# ---------- FUNKCIJE ----------

function Log($msg) {
    $line = "$(Get-Date -Format 'yyyy-MM-dd HH:mm:ss')  $msg"
    Add-Content -Path $logFile -Value $line
}

# samo za statistiku, da znamo da li neko radi u trenutku prvog restarta
function Get-AdsActiveConnections {
    param([int]$Port)

    try {
        $pattern = "[:\.]$Port\s"
        $output = netstat -an 2>$null | Select-String $pattern | Where-Object { $_.Line -match 'ESTABLISHED' }
        return ($output | Measure-Object).Count
    }
    catch {
        return 0
    }
}

# ---------- PRONADJI ADVANTAGE SERVIS ----------

$service = Get-Service |
    Where-Object { $_.DisplayName -like "*Advantage*" -or $_.Name -like "*Advantage*" } |
    Select-Object -First 1

if (-not $service) {
    Log "GRESKA: Nisam nasao Advantage servis (po imenu/display name-u). Izlazim."
    exit 1
}

$serviceName = $service.Name
Log "Pronadjen Advantage servis: Name='$serviceName', DisplayName='${($service.DisplayName)}'."

# ---------- PAMETNI PRVI RESTART POSLE BOOT-A ----------

Log "Watchdog (SAFE) startuje. Cekam $initialDelaySeconds sekundi pre provere za prvi restart..."
Start-Sleep -Seconds $initialDelaySeconds

$activeConns = Get-AdsActiveConnections -Port $adsPort
if ($activeConns -eq 0) {
    try {
        Log "Nema aktivnih konekcija na portu $adsPort (0 konekcija). Radim sigurnosni prvi restart servisa '$serviceName'..."
        Restart-Service -Name $serviceName -Force
        Log "Prvi restart zavrsen."
    }
    catch {
        Log "GRESKA pri prvom restartu: $($_.Exception.Message)"
    }
}
else {
    Log "Prvi restart PRESKOCEN: detektovano $activeConns aktivnih konekcija na portu $adsPort (klijenti vec rade) - ne diram servis."
}

Log "Watchdog (SAFE) zavrsio rad za ovaj boot - nema daljih restarta."
