@echo off
REM ============================================
REM  ADS Watchdog SAFE za Windows XP (sa proverom konekcija)
REM  Radi SAMO jedan sigurnosni restart posle boota,
REM  i to SAMO ako nema aktivnih konekcija na ADS portu.
REM ============================================

REM ----- PODESIVI PARAMETRI -----
set SERVICE_NAME=Advantage Database Server
set PORT=6262
set INIT_DELAY=60

REM log fajl
set LOG_FILE=C:\ADS_Watchdog\ads-xp-watchdog.log

if not exist C:\ADS_Watchdog mkdir C:\ADS_Watchdog

REM rotacija loga - ako je veci od ~5MB, brisemo ga
if exist "%LOG_FILE%" (
    for %%F in ("%LOG_FILE%") do (
        if %%~zF GTR 5000000 del "%LOG_FILE%"
    )
)

echo ============================================>>"%LOG_FILE%"
echo %DATE% %TIME%  Watchdog SAFE (sa proverom konekcija) startuje...>>"%LOG_FILE%"

REM ----- FUNKCIJE (preko labela) -----

:log
REM %1 = tekst
echo %DATE% %TIME%  %~1>>"%LOG_FILE%"
goto :eof

:delay
REM %1 = sekunde (approx)
set /a _sec=%1+1
ping 127.0.0.1 -n %_sec% >nul
goto :eof

REM ----- PRVI (I JEDINI) RESTART POSLE BOOTA -----
call :log "Cekam %INIT_DELAY% sekundi pre provere za sigurnosni restart..."
call :delay %INIT_DELAY%

REM Provera da li ima aktivnih ESTABLISHED konekcija na portu
set HAS_CONN=0
for /f "tokens=* delims=" %%L in ('netstat -an ^| find ":%PORT% " ^| find "ESTABLISHED"') do (
    set HAS_CONN=1
    goto AfterConnCheck
)

:AfterConnCheck
if "%HAS_CONN%"=="0" (
    call :log "Nema aktivnih konekcija na portu %PORT% (0 konekcija). Radim sigurnosni restart servisa '%SERVICE_NAME%'..."
    net stop "%SERVICE_NAME%" >nul 2>&1
    net start "%SERVICE_NAME%" >nul 2>&1
    call :log "Sigurnosni restart zavrsen. Watchdog SAFE (sa proverom konekcija) zavrsava rad za ovaj boot."
) else (
    call :log "Prvi restart PRESKOCEN: detektovana je bar jedna aktivna konekcija na portu %PORT% (klijenti vec rade) - ne diram servis."
    call :log "Watchdog SAFE (sa proverom konekcija) zavrsava rad za ovaj boot."
)

goto :eof
