# MonitorInternet.ps1
# Monitors internet connection and restarts or starts the 'Advantage' service when internet reconnects

$serviceName = "Advantage"
$checkInterval = 10  # seconds
$logFile = "$PSScriptRoot\InternetMonitor.log"
$wasOffline = $false

function Log {
    param ([string]$msg)
    $timestamp = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
    Add-Content -Path $logFile -Value "$timestamp  -  $msg"
}

Log "Script started. Monitoring internet status..."

while ($true) {
    $online = Test-Connection -ComputerName 8.8.8.8 -Count 1 -Quiet -ErrorAction SilentlyContinue
    if ($online) {
        if ($wasOffline) {
            Log "Internet is back ONLINE. Checking '$serviceName' service..."
            try {
                $svc = Get-Service -Name $serviceName
                if ($svc.Status -eq 'Stopped') {
                    Start-Service -Name $serviceName
                    Log "Service '$serviceName' was stopped. Started successfully."
                } else {
                    Restart-Service -Name $serviceName -Force
                    Log "Service '$serviceName' restarted successfully."
                }
            } catch {
                Log "ERROR managing service: $_"
            }
            $wasOffline = $false
        }
    } else {
        if (-not $wasOffline) {
            Log "Internet is OFFLINE."
            $wasOffline = $true
        }
    }
    Start-Sleep -Seconds $checkInterval
}
