# RotateLog.ps1
# Keeps InternetMonitor.log from growing too large

$logFile = "C:\Scripts\InternetMonitor.log"
$archiveFolder = "C:\Scripts\LogArchive"
$maxSizeMB = 5  # Maximum log size before rotation

# Ensure archive folder exists
if (-not (Test-Path $archiveFolder)) {
    New-Item -ItemType Directory -Path $archiveFolder | Out-Null
}

# Check log size
if (Test-Path $logFile) {
    $sizeMB = (Get-Item $logFile).Length / 1MB
    if ($sizeMB -ge $maxSizeMB) {
        $timestamp = Get-Date -Format "yyyyMMdd_HHmmss"
        $archivedLog = Join-Path $archiveFolder "InternetMonitor_$timestamp.log"
        Rename-Item -Path $logFile -NewName $archivedLog
        # Create a new empty log
        New-Item -Path $logFile -ItemType File | Out-Null
    }
}
