@echo off
echo ===============================
echo Installing Internet Monitor...
echo ===============================

net session >nul 2>&1
if %errorlevel% NEQ 0 (
  echo This installer must be run as Administrator.
  pause
  exit /b 1
)

if not exist "C:\Scripts" (
    mkdir "C:\Scripts"
)

set "src=%~dp0"

copy /Y "%src%MonitorInternet.ps1" "C:\Scripts\MonitorInternet.ps1" >nul
copy /Y "%src%RestartAdvantageTask.xml" "C:\Scripts\RestartAdvantageTask.xml" >nul
copy /Y "%src%RestartAdvantageTask2.xml" "C:\Scripts\RestartAdvantageTask2.xml" >nul
copy /Y "%src%RotateLog.ps1" "C:\Scripts\RotateLog.ps1" >nul

schtasks /Create /TN "RestartAdvantage" /XML "C:\Scripts\RestartAdvantageTask.xml" /F
schtasks /Create /TN "RestartAdvantageMonitor" /XML "C:\Scripts\RestartAdvantageTask2.xml" /F

echo Creating daily log rotation task...
schtasks /Create /TN "InternetMonitorLogRotate" /SC DAILY /ST 02:00 /RL HIGHEST /TR "powershell.exe -ExecutionPolicy Bypass -File C:\Scripts\RotateLog.ps1" /F

echo Running initial boot task to test service handling...
schtasks /Run /TN "RestartAdvantage"

echo.
echo Installation complete!
pause
