@echo off
echo ===============================
echo Installing Internet Monitor...
echo ===============================

net session >nul 2>&1
if %errorlevel% NEQ 0 (
    echo This installer must be run as Administrator.
    pause
    exit /b 1
)

set NEED_RESTART=0

REM --- Safety Check: SP1 (Automatska instalacija) ---
echo Checking for Windows 7 SP1...
systeminfo | findstr /C:"Service Pack 1" >nul
if %errorlevel% NEQ 0 (
    echo SP1 not detected!
    if exist "%SystemRoot%\SysWOW64" (
        set "ARCH=x64"
        set "SP1_URL=https://download.microsoft.com/download/1/1/0/110.../windows6.1-KB976932-X64.exe"
    ) else (
        set "ARCH=x86"
        set "SP1_URL=https://download.microsoft.com/download/1/1/0/110.../windows6.1-KB976932-X86.exe"
    )
    echo Detected %ARCH% system.
    echo Downloading SP1 installer...
    powershell -Command "Invoke-WebRequest -Uri '%SP1_URL%' -OutFile '%TEMP%\Win7SP1.exe'"
    echo Installing SP1 silently...
    start /wait "%TEMP%\Win7SP1.exe" /quiet /norestart
    echo SP1 installation triggered.
    set NEED_RESTART=1
)

REM --- Safety Check: .NET ---
echo Checking installed .NET versions...
reg query "HKLM\SOFTWARE\Microsoft\NET Framework Setup\NDP\v4\Full" /v Release >nul 2>&1
if %errorlevel% NEQ 0 (
    echo .NET 4.5+ not found. Installing silently...
    start /wait dotNetFx45_Full_setup.exe /q /norestart
    set NEED_RESTART=1
)

REM --- Safety Check: PowerShell 5.1 ---
powershell -Command "$PSVersionTable.PSVersion.Major" | findstr /R "^5$" >nul
if %errorlevel% NEQ 0 (
    echo PowerShell 5.1 not found. Installing silently...
    start /wait Win7PowerShell51.msi /quiet /norestart
    set NEED_RESTART=1
)

REM --- Create Scripts folder ---
if not exist "C:\Scripts" mkdir "C:\Scripts"
set src=%~dp0

copy /Y "%src%MonitorInternet.ps1" "C:\Scripts\MonitorInternet.ps1"
copy /Y "%src%RestartAdvantageTask.xml" "C:\Scripts\RestartAdvantageTask.xml"
copy /Y "%src%RestartAdvantageTask2.xml" "C:\Scripts\RestartAdvantageTask2.xml"
copy /Y "%src%RotateLog.ps1" "C:\Scripts\RotateLog.ps1"

REM --- Create scheduled tasks ---
schtasks /Create /TN "RestartAdvantage" /XML "C:\Scripts\RestartAdvantageTask.xml" /F
schtasks /Create /TN "RestartAdvantageMonitor" /XML "C:\Scripts\RestartAdvantageTask2.xml" /F
schtasks /Create /TN "InternetMonitorLogRotate" /SC DAILY /ST 02:00 /RL HIGHEST /TR "powershell.exe -ExecutionPolicy Bypass -File C:\Scripts\RotateLog.ps1" /F

REM --- Run initial boot test ---
schtasks /Run /TN "RestartAdvantage"

echo.
echo Installation complete!

REM --- Prompt user to restart only if something was installed ---
if %NEED_RESTART%==1 (
    echo.
    choice /M "Some components were installed. Do you want to restart your computer now? (y/n)"
    if %errorlevel%==1 (
        echo Restarting computer...
        shutdown /r /t 5
    ) else (
        echo You can restart later to activate the changes.
    )
) else (
    echo.
    echo All components already installed. No restart needed.
)

pause
