# RotateLog.ps1
# Keeps InternetMonitor.log from growing too large

$logFile = "C:\Scripts\InternetMonitor.log"
$archiveFolder = "C:\Scripts\LogArchive"
$maxSizeMB = 5  # Maximum log size before rotation

if (-not (Test-Path $archiveFolder)) { New-Item -ItemType Directory -Path $archiveFolder | Out-Null }

if (Test-Path $logFile) {
    $sizeMB = (Get-Item $logFile).Length / 1048576
    if ($sizeMB -ge $maxSizeMB) {
        $timestamp = Get-Date -Format "yyyyMMdd_HHmmss"
        $archivedLog = Join-Path $archiveFolder "InternetMonitor_$timestamp.log"
        Rename-Item -Path $logFile -NewName $archivedLog
        New-Item -Path $logFile -ItemType File | Out-Null
    }
}